<Query Kind="Statements" />

Console.WriteLine("DZIENNIKI NA TYM KOMPUTERZE");
foreach (EventLog l in EventLog.GetEventLogs())
{
	try
	{
		Console.WriteLine (l.LogDisplayName);
	}
	catch (Exception ex)
	{
		// Nazwa może być niedostępna, ale ta własność i tak będzie dostępna
		Console.WriteLine ($"Błąd przetwarzania dziennika zdarzeń „{l.Log}”: {ex.Message}");
	}
}

Console.WriteLine();
Console.WriteLine ("DZIENNIK ZDARZEŃ aplikacji");

EventLog log = new EventLog ("Application");

Console.WriteLine ("Total entries: " + log.Entries.Count);

EventLogEntry last = log.Entries [log.Entries.Count - 1];
Console.WriteLine ("Index:   " + last.Index);
Console.WriteLine ("Source:  " + last.Source);
Console.WriteLine ("Type:    " + last.EntryType);
Console.WriteLine ("Time:    " + last.TimeWritten);
Console.WriteLine ("Message: " + last.Message);

log.EnableRaisingEvents = true;
log.EntryWritten += DisplayEntry;

// Monitorowanie wpisów w dzienniku zdarzeń przez 60 sekund
// W LINQPad możesz wcześniej zatrzymać zapytanie
Thread.Sleep(60 * 1000); 

static void DisplayEntry (object sender, EntryWrittenEventArgs e)
{
	EventLogEntry entry = e.Entry;
	Console.WriteLine (entry.Message);
}